const fs = require('fs').promises;
const path = require('path');
const process = require('process');
const {google} = require('googleapis');

// The file token.json stores the user's access and refresh tokens, and is
// created automatically when the authorization flow completes for the first
// time.
const TOKEN_PATH = path.join(process.cwd(), 'GoogleDrive/token.json');

async function loadSavedCredentialsIfExist() {
  try {
    const content = await fs.readFile(TOKEN_PATH);
    const credentials = JSON.parse(content);
    return google.auth.fromJSON(credentials);
  } catch (err) {
    return null;
  }
}

async function authorize() {
  let client = await loadSavedCredentialsIfExist();
  return client;
}

async function listFiles(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});
  const res = await drive.files.list({
    mimeType: 'application/vnd.google-apps.folder',
    pageSize: 10,
    fields: "*",
  });

  // drive.files.get({
  //   mimeType: 'application/vnd.google-apps.folder',
  //     // auth: jwtClient,
  //     fileId: fileId,
  //     fields : "thumbnailLink"
  // }, function (err, res) {
  //       // console.log(response)
  //       const files = res.data.files;
  //     if (files.length === 0) {
  //       console.log('No files found.');
  //       return;
  //     }
  //     console.log(res);
  // })
  

  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }

  console.log('Files:');
  files.map((file) => {
    console.log(`${file.name} (${file.id}) thumbnailLink: (${file.thumbnailLink})`);
    if(file.id === "12NjGx3iUh1SL3N1eo9Eca8zt9zDREFtU"){
      console.log(file)
    }
  });

  // console.log('Folder:');
  // let NextPageToken = "";
  // // var fileId = '1ygFxVw3wJ_0IB57Mbtgr3xL3f_d9dUdY' //mp3 bayanaat
  // // var fileId = '1a87qy2LSD1GvoxQHOqVNlJasoDtfO3f6' //Recording old laptop
  // var fileId = '1U1B5yPWVe7cP6O6v8gjK4TMvsQpQk9tC' //Recording New laptop (Current)
  // drive.files.list({
  //     includeRemoved: false,
  //     // orderBy: "name",
  //     pageSize: 1000,
  //     spaces: 'drive',
  //     fileId: fileId,
  //     pageToken: NextPageToken || "",
  //     // trashed: false,
  //     fields: 'nextPageToken, files',
  //     q: `'${fileId}' in parents`
  // }, function (err, res) {
  //     // console.log(response)
  //     const files = res.data.files;
  //   if (files.length === 0) {
  //     console.log('No files found.');
  //     return;
  //   }

  //   console.log('MP3 Bayanaat Files:');
  //   files.map((file, index) => {
  //     console.log(`${index} ${file.name} modifiedTime: (${file.modifiedTime}) createdTime: (${file.createdTime}) `);
  //     // console.log(`${index} ${file.name} modifiedTime: (${file.modifiedTime})  webViewLink: ${file.webViewLink}  webContentLink: ${file.webContentLink}`);
  //     // if(file.id === "1ygFxVw3wJ_0IB57Mbtgr3xL3f_d9dUdY"){
  //       // console.log(file)
  //     // }
  //   });
  // });
}

async function listFilesByAllIdsfromDrive(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});
  const res = await drive.files.list({
    q: "mimeType = 'application/vnd.google-apps.folder'",
    pageSize: 100,
    fields: "files(id, name)",
  });

  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return "'No files found.'";
  }

  let array = new Array();
  files.map((file) => {
    array.push(`${file.id} (${file.name})`)
  });

  return array
  
}

//Bayanaat + Asfaar
async function listFilesByAllIdsForMasbBayanAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});
  let NextPageToken = "";
  var fileId = '1U1B5yPWVe7cP6O6v8gjK4TMvsQpQk9tC' //Recording New laptop (Current)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });

  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function getParentFolderName(authClient, fileId) {
  const drive = google.drive({ version: "v3", auth: authClient });

  // get file details including parents
  const fileRes = await drive.files.get({
    fileId: fileId,
    fields: "id, name, parents"
  });

  const file = fileRes.data;
  if (!file.parents || file.parents.length === 0) {
    return {};
  }

  const parentId = file.parents[0];

  // get parent folder details
  const parentRes = await drive.files.get({
    fileId: parentId,
    fields: "id, name, mimeType"
  });

  return {'name' : `${parentRes.data.name}`, 'id' : `${parentRes.data.id}`};
}


async function listFilesByAllIdsForMasbAsfaarAudio(authClient) {
    const drive = google.drive({ version: 'v3', auth: authClient });
  const rootFolderId = '1dnxpYiO2CWCFx0kDZAFaYJiZRB0ozgPH'; // Asfaar
  const visitedFolders = new Set();

  async function fetchFiles(folderId) {
    let allFiles = [];
    let nextPageToken = null;

    // infinite loop rokne k liye
    if (visitedFolders.has(folderId)) return [];
    visitedFolders.add(folderId);

    do {
      const res = await drive.files.list({
        q: `'${folderId}' in parents and trashed = false`,
        includeRemoved: false,
        pageSize: 1000,
        spaces: 'drive',
        pageToken: nextPageToken || "",
        fields:
          'nextPageToken, files(id, name, mimeType, parents, webViewLink, webContentLink, createdTime, modifiedTime)'
      });

      const files = res.data.files || [];

      for (const file of files) {
        if (file.mimeType === 'application/vnd.google-apps.folder') {
          // agar folder mila to uske andar bhi jao
          const subFiles = await fetchFiles(file.id);
          allFiles = allFiles.concat(subFiles);
        } else {
          allFiles.push(file);
        }
      }

      nextPageToken = res.data.nextPageToken;
    } while (nextPageToken);

    return allFiles;
  }

  // root folder se start karna hai
  return await fetchFiles(rootFolderId);
}

async function listFilesByAllIdsForHsssBayanAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = "1Vj-cE-ytPZOiURaFhgMPe7R4_b85qt2R"// ((Bayanaat) Hazrat Sufi Shamim SB RA)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function listFilesByAllIdsForHsssAsfaarAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '1aBdEVNO31n45evuuq_hk6PXrpZVolaEh' //(Asfaar) Hazrat Sufi Shamim SB RA)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function listFilesByAllIdsForHmasBayanAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = "19tSTJ4rDMD42SxuNRU44utwcVkrPs0QI"// ((Bayanaat) Arif Billah Hazrat Aqdas Molana Shah Hakeem Muhammad Akhtar Sb RA)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function listFilesByAllIdsForHmasAsfaarAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '1FkSMi2okokKi_vnC8tZds6eiY_-RpThm' //(Asfaar) Arif Billah Hazrat Aqdas Molana Shah Hakeem Muhammad Akhtar Sb RA
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function listFilesByAllIdsForHmmsBayanAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = "14X7Z7gvo88VWigHAUE8vtPiEdgLiFyLT" // ((Bayanaat) Arif Billah Hazrat Aqdas Molana Shah Hakeem Muhammad Mazhar SB DB)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function listFilesByAllIdsForHmmsAsfaarAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '1baKqi1FYfbkp2Nlz7wRisAB4QQewQjOA' //((Asfaar) Arif Billah Hazrat Aqdas Molana Shah Hakeem Muhammad Mazhar SB DB)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

//Ashaar
async function listFilesByAllIdsForAshaarAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '1U1B5yPWVe7cP6O6v8gjK4TMvsQpQk9tC' //Recording New laptop (Current)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function listFilesByAllIdsForMASSAshaarAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '1U1B5yPWVe7cP6O6v8gjK4TMvsQpQk9tC' //Recording New laptop (Current)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function listFilesByAllIdsForMIKSAshaarAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '1U1B5yPWVe7cP6O6v8gjK4TMvsQpQk9tC' //Recording New laptop (Current)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function listFilesByAllIdsForMQRSAshaarAudio(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '1U1B5yPWVe7cP6O6v8gjK4TMvsQpQk9tC' //Recording New laptop (Current)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

//PDF
async function listFilesByPdfIdsForHmasUrduPdf(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '1DiK_wpoK1WG4sIJs91XiyOcJgWVnITKX'
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

async function listFilesByPdfIdsForHmasEngPdf(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '1ss0I0U4l-1d2utLzqFnDXFR4Q7mRtAcM' //Books
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return[];
  }
  else{
    return files
  }
  
}

async function listFilesByPdfIdsForHmmsEngPdf(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  // var fileId = '1U1B5yPWVe7cP6O6v8gjK4TMvsQpQk9tC' //Recording New laptop (Current)
  var fileId = '' //Books
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return[];
  }
  else{
    return files
  }
  
}

async function listFilesByPdfIdsForHmmsUrduPdf(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  // var fileId = '1U1B5yPWVe7cP6O6v8gjK4TMvsQpQk9tC' //Recording New laptop (Current)
  var fileId = '1Rw8oS57QdfRmZDhXeP5HYSHymfw2hoCs' //Books
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return[];
  }
  else{
    return files
  }
  
}

//for all files by file Video id
async function listFilesByAllVideoId(authClient, fileId) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return [];
  }
  else{
    return files
  }
  
}

async function listFilesByAllIdsForMasbShortVideo(authClient) {
  const drive = google.drive({version: 'v3', auth: authClient});

  console.log('Folder:');
  let NextPageToken = "";
  var fileId = '12wD3EraFNyt0b8-Ey0YwWFftQ8BDRvQX' //ASSshortVideos (12wD3EraFNyt0b8-Ey0YwWFftQ8BDRvQX)
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return;
  }
  else{
    return files
  }
  
}

//for thumbnail
async function listFilesByAllIdsForThumbnail(authClient,id) {
  const drive = google.drive({version: 'v3', auth: authClient});
  let NextPageToken = "";
  var fileId = id 
  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });

  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return [];
  }
  else{
    return files
  }
  
}


//for all files by file id with sub folder
async function listFilesByAllIdWithSubFolder(authClient, fileId) {
  const drive = google.drive({ version: 'v3', auth: authClient });
  const rootFolderId = fileId;
  const visitedFolders = new Set();

  async function fetchFiles(folderId) {
    let allFiles = [];
    let nextPageToken = null;

    if (visitedFolders.has(folderId)) return [];
    visitedFolders.add(folderId);

    try {
      do {
        const res = await drive.files.list({
          q: `'${folderId}' in parents and trashed = false`,
          includeRemoved: false,
          pageSize: 1000,
          spaces: 'drive',
          pageToken: nextPageToken || "",
          fields:
            'nextPageToken, files(id, name, mimeType, parents, webViewLink, webContentLink, createdTime, modifiedTime)'
        });

        const files = res.data.files || [];

        for (const file of files) {
          if (file.mimeType === 'application/vnd.google-apps.folder') {
            const subFiles = await fetchFiles(file.id);
            allFiles = allFiles.concat(subFiles);
          } else {
            allFiles.push(file);
          }
        }

        nextPageToken = res.data.nextPageToken;
      } while (nextPageToken);
    } catch (err) {
      console.error(`❌ Error fetching folder ${folderId}:`, err.message);
      throw new Error(`Invalid or inaccessible folder ID: ${folderId}`);
    }

    return allFiles;
  }

  // Start from root folder
  return await fetchFiles(rootFolderId);
}

//for all files by file Book id
async function listFilesByAllBookId(authClient, fileId) {
  const drive = google.drive({version: 'v3', auth: authClient});

  let NextPageToken = "";

  const res =  await drive.files.list({
      includeRemoved: false,
      // orderBy: "name",
      pageSize: 1000,
      spaces: 'drive',
      fileId: fileId,
      pageToken: NextPageToken || "",
      // trashed: false,
      fields: 'nextPageToken, files',
      q: `'${fileId}' in parents`
  });


  const files = res.data.files;
  if (files.length === 0) {
    console.log('No files found.');
    return[];
  }
  else{
    return files
  }
  
}


//rename file
async function renameFile(authClient, name, fileId) {
  const drive = await google.drive({version: 'v3', auth: authClient});
  var body = {'name': name};
  return  await drive.files.update({
      fileId: fileId,
      resource: body,
      // }
      // , (err, res) => {
      //   if (err) {
      //     console.log('The API returned an error: ' + err);
      //     return 'The API returned an error: ' + err
      //   }
      //   else {
      //     console.log('The name of the file has been updated!');
      //     return "The name of the file has been updated!"
      //   }
      });
}





exports.syncFileIdsfromDrive = async () => {
  const response = await authorize().then(
    listFilesByAllIdsfromDrive).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

//Bayanaat + Asfaar
exports.syncFileByFieldIdsForMasbBayanAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForMasbBayanAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncParentFolderName = async (fileId) => {
  const response = await authorize().then(async (authClient)=> {
   return  await getParentFolderName(authClient,fileId)
  }).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForMasbAsfaarAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForMasbAsfaarAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForHsssBayanAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForHsssBayanAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForHsssAsfaarAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForHsssAsfaarAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForHmasBayanAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForHmasBayanAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForHmasAsfaarAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForHmasAsfaarAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForHmmsBayanAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForHmmsBayanAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForHmmsAsfaarAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForHmmsAsfaarAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

//Ashaar
exports.syncFileByFieldIdsForAshaarAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForAshaarAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForMASSAshaarAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForMASSAshaarAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForMIKSAshaarAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForMIKSAshaarAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForMQRSAshaarAudio = async () => {
  const response = await authorize().then(listFilesByAllIdsForMQRSAshaarAudio).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

//PDF
exports.syncFileByFieldIdsForHmasUrduPdf = async () => {
  const response = await authorize().then(listFilesByPdfIdsForHmasUrduPdf).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForHmasEngPdf = async () => {
  const response = await authorize().then(listFilesByPdfIdsForHmasEngPdf).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForHmmsEngPdf = async () => {
  const response = await authorize().then(listFilesByPdfIdsForHmmsEngPdf).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForHmmsUrduPdf = async () => {
  const response = await authorize().then(listFilesByPdfIdsForHmmsUrduPdf).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

//All Videos
exports.syncFileByFieldIdForAllVideo = async (fileId) => {
   const response = await authorize().then(async (authClient)=> {
   return  await listFilesByAllVideoId(authClient,fileId)
  }).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

exports.syncFileByFieldIdsForMasbShortVideo = async () => {
  const response = await authorize().then(listFilesByAllIdsForMasbShortVideo).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

//For thumbnail
exports.syncFileByFieldIdsForThumbnail = async (fileId) => {
  const response = await authorize().then(async (authClient)=> {
   return  await listFilesByAllIdsForThumbnail(authClient,fileId)
  }).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

//For All files by fileId with sub folder
exports.syncFileByFileIdWithSubFolder = async (fileId) => {
  const response = await authorize().then(async (authClient)=> {
   return  await listFilesByAllIdWithSubFolder(authClient,fileId)
  }).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

//Book For All files by fileId with sub folder
exports.syncFileByFieldIdForBook = async (fileId) => {
   const response = await authorize().then(async (authClient)=> {
   return  await listFilesByAllBookId(authClient,fileId)
  }).catch((error)=>
  {
    console.log(error)
    return error
  });
  return response;
};

//For rename file
exports.renameFilebyFileId = async (fileId, name) => {
  const response = await authorize().then(async (authClient)=> {
     await renameFile(authClient, name, fileId)
     .then((result) => {
      console.log(result)
      return result;
    })
    .catch((err)=>{
      console.log(err)
      return err;
    })
  }).catch(()=>{
      console.error
    });
    return response;
};