const { category, person, type } = require("../../constants/dbConstants");
const Audio = require("../../database/models/audio");
const Group = require("../../database/models/group.js");
const pdf = require("../../database/models/pdf");
const video = require("../../database/models/video");
const GoogleDrive = require("../../GoogleDrive/index.js");
const { extractAllFromFileName, extractAllFromFileNameSpeech, formatIndexSpeech, extractAllFromPdfFiles, formatIndexForPdf, extractAllFromAshaarFileName, extractAllFromShortVideoFiles, formatIndex, formatIndexForShortVideo, formatIndexForFilesGeneral, extractAllFromFilesGeneral, formatAshaarIndex, extractAllFromFileMASSSpeech, formatIndexMASSSpeech, extractDescriptionFromTitle, formatIndexForDescription } = require("../helpers/helper");
const https = require('https');
const fs = require('fs');
const { driveBayanaatMASSIdsForSync, driveBayanaatIdsForSync, driveAsfaarBayanaatIdsForSync, drivePoetryIdsForSync, driveVideoIdsForSync, driveBookIdsForSync } = require("../../GoogleDrive/Ids");
const { authorizeGoogleAuth, setAuthCallback } = require("../../GoogleDrive/googleAuth.js");
const path = require("path");


// Get the authentication URL
exports.authorizeGoogleAuth = async (req, res, next) => {
  try {
    const url = await authorizeGoogleAuth();
    res.send(url)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

// Handle the redirect from the authentication flow
exports.googleAuthCallback = async (req, res, next) => {
  const code = req.query.code;
  try {
    await setAuthCallback(code)
    res.send('Authentication successful!');
  } catch (e) {
    res.statusCode = 500;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.syncAllIdsfromDrive = async (req, res, next) => {
  try {
    const response = await GoogleDrive.syncFileIdsfromDrive()
    res.send(response)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

//sync data for all ids with their thumbnails
exports.syncDriveFromFresh = async (req, res, next) => {
  try {
    const FilesIds = driveFileIdsForSync;

    FilesIds.forEach(async (fileItem, index) => {
      var id = fileItem.id;
      console.log(id)
      const files = await GoogleDrive.syncFileByFileIds(id)

      switch (fileItem.type) {
        case type.Speech:
          await syncForSpeech(fileItem, files)
          break;
        case type.Poetry:
          await syncForPoetry(fileItem, files)
          break;
        case type.Book:
          await syncForPdf(fileItem, files)
          break;
        case type.Video:
          await syncForVideo(fileItem, files)
          break;
        default:
        // code block
      }

    })


    res.send("Successfully")

  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

//rename file on drive renameFilebyFileId
exports.renameFileFromDriveByFileId = async (req, res, next) => {
  try {
    const { fileId, name } = req.body;
    if (fileId !== null || fileId !== undefined) {
      await GoogleDrive.renameFilebyFileId(fileId, name)
        .then((result) => {
          // console.log(result)
          res.send("Rename Successfully")
        })
        .catch((err) => {
          console.log(err)
          res.send("Rename Not updated" + err)
        })
    }
    else {
      res.send("fileId not empty")
    }
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

const syncForSpeech = async (fileItems, files) => {
  let categoryId = fileItems.category
  let personId = fileItems.person
  if (categoryId == category.Speech) {
    if (personId == person.Hazrat_Aqdas_Molana_Abid_Shah_Sahab_Damat_Barkatuhum) {
      await syncForSpeechMASS(files)
      return
    }
  }
  await syncForSpeechGeneral(files, categoryId, personId)
}

// const syncForSpeechMASS = async (files) => {

//   if (files instanceof Array) {

//   }
//   else {
//     res.send("List empty")
//     return
//   }

//   var entries = [];
//   files.forEach((file, index) => {
//     let item = extractAllFromFileNameSpeech(file.name, file.createdTime, file.modifiedTime)
//     let temp = {
//       orignalId: file.id ? file.id : index,
//       name: item[formatIndexSpeech.name],
//       categoryId: category.Speech,
//       personId: person.Hazrat_Aqdas_Molana_Abid_Shah_Sahab_Damat_Barkatuhum,
//       title: item[formatIndexSpeech.title],
//       description: item[formatIndexSpeech.name],
//       place: item[formatIndexSpeech.place],
//       islamiDate: item[formatIndexSpeech.islamiDate],
//       viewLink: file.webViewLink,
//       contentLink: file.webContentLink,
//       fileExtension: item[formatIndexSpeech.extension],
//       date: item[formatIndexSpeech.date],
//       createdAt: file.createdTime,
//       updatedAt: file.modifiedTime,
//     }
//     entries.push(temp)
//   });
//   await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })
// }

// const syncForSpeechGeneral = async (files, categoryId, personId) => {
//   var entries = [];
//   files.forEach((file, index) => {
//     let item = extractAllFromFileNameSpeech(file.name, file.createdTime, file.modifiedTime)
//     let temp = {
//       orignalId: file.id ? file.id : index,
//       name: item[formatIndexSpeech.name],
//       categoryId: categoryId,
//       personId: personId,
//       title: item[formatIndexSpeech.title],
//       description: item[formatIndexSpeech.description],
//       place: item[formatIndexSpeech.place],
//       islamiDate: item[formatIndexSpeech.islamiDate],
//       viewLink: file.webViewLink,
//       contentLink: file.webContentLink,
//       fileExtension: item[formatIndexSpeech.extension],
//       date: item[formatIndexSpeech.date],
//       createdAt: file.createdTime,
//       updatedAt: file.modifiedTime,
//     }
//     entries.push(temp)
//   });
//   await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })
// }

const syncForPoetry = async (fileItems, files) => {
  let categoryId = fileItems.category
  let personId = fileItems.person
  await syncForPoetryGeneral(files, categoryId, personId)
}

// const syncForPoetryGeneral = async (files, categoryId, personId) => {
//   var entries = [];
//   files.forEach((file, index) => {
//     let item = extractAllFromFilesGeneral(file.name, file.createdTime, file.modifiedTime)
//     let temp = {
//       orignalId: file.id ? file.id : index,
//       categoryId: categoryId,
//       personId: personId,
//       name: item[formatIndexForFilesGeneral.name],
//       title: item[formatIndexForFilesGeneral.title],
//       description: item[formatIndexForFilesGeneral.description],
//       place: item[formatIndexForFilesGeneral.place],
//       islamiDate: item[formatIndexForFilesGeneral.islamiDate],
//       viewLink: file.webViewLink,
//       contentLink: file.webContentLink,
//       fileExtension: item[formatIndexForFilesGeneral.extension],
//       date: item[formatIndexForFilesGeneral.date],
//       createdAt: file.createdTime,
//       updatedAt: file.modifiedTime,
//     }
//     entries.push(temp)
//   });
//   await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })
// }

const syncForPdf = async (fileItems, files) => {
  let categoryId = fileItems.category
  let personId = fileItems.person
  let isThumbnail = fileItems.isThumbnail
  await syncForPdfGeneral(files, categoryId, personId)
}

const syncForPdfGeneral = async (files, categoryId, personId) => {
  var entries = [];
  files.forEach((file, index) => {
    let item = extractAllFromPdfFiles(file.name)

    var name = item[formatIndexForFilesGeneral.title]
    name = name.replaceAll(" ", "_");
    name = name.replaceAll("-", "_");
    let ThumbnailFileName = name + ".jpg";
    var path = "./uploads/" + ThumbnailFileName;

    fs.readFile(path, (err, data) => {
      console.log(err ? 'it exists' : 'no passwd!');
      if (err) {
        console.log('enter in if');
        downloadImageToUrl(file.thumbnailLink, path);
      }
    })

    let temp = {
      orignalId: file.id ? file.id : index,
      categoryId: categoryId,
      personId: personId,
      name: item[formatIndexForPdf.name],
      title: item[formatIndexForPdf.title],
      viewLink: file.webViewLink,
      contentLink: file.webContentLink,
      fileExtension: item[formatIndexForPdf.extension],
      iconLink: file.iconLink,
      thumbnailLink: ThumbnailFileName,
      createdAt: file.createdTime,
      updatedAt: file.modifiedTime,
    }
    entries.push(temp)
  });
  await pdf.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })
}

const syncForVideo = async (fileItems, files) => {
  let categoryId = fileItems.category
  let personId = fileItems.person
  let isThumbnail = fileItems.isThumbnail
  await syncForVideoGeneral(files, categoryId, personId)
}

const syncForVideoGeneral = async (files, categoryId, personId) => {
  var entries = [];
  files.forEach((file, index) => {

    let item = extractAllFromFilesGeneral(file.name)

    var name = item[formatIndexForFilesGeneral.title]
    name = name.replaceAll(" ", "_");
    name = name.replaceAll("-", "_");
    let ThumbnailFileName = name + ".jpg";
    var path = "./uploads/" + ThumbnailFileName;

    fs.readFile(path, (err, data) => {
      console.log(err ? 'it exists' : 'no passwd!');
      if (err) {
        console.log('enter in if');
        downloadImageToUrl(file.thumbnailLink, path);
      }
    })

    let temp = {
      orignalId: file.id ? file.id : index,
      categoryId: categoryId,
      personId: personId,
      name: item[formatIndexForFilesGeneral.name],
      title: item[formatIndexForFilesGeneral.title],
      viewLink: file.webViewLink,
      contentLink: file.webContentLink,
      fileExtension: item[formatIndexForFilesGeneral.extension],
      iconLink: file.iconLink,
      thumbnailLink: ThumbnailFileName,
      createdAt: file.createdTime,
      updatedAt: file.modifiedTime,
    }
    entries.push(temp)
  });
  await video.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })
}

//for Audios
exports.syncDriveFromFreshForMasbBayanAudio = async (req, res, next) => {
  try {
    const files = await GoogleDrive.syncFileByFieldIdsForMasbBayanAudio()
    await syncForSpeechMASS(files)
    res.send("Insert Successfully")
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

//Asfaar bayanaat
// exports.syncDriveFromFreshForMasbAsfaarAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForMasbAsfaarAudio()

//     console.log('MP3 Bayanaat Files:');

//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }

//     let entries = await Promise.all(files.map(async (file, index) => {
//       let item = extractAllFromFileName(file.name, file.createdTime, file.modifiedTime);
//       var parent = null;
//       try {
//         parent = await GoogleDrive.syncParentFolderName(file.id);
//       } catch (err) {
//         console.error(`Error getting parent for file ${file.id}:`, err.message);
//         parent = "Unknown"; // fallback value
//       }

//       return {
//         orignalId: file.id ?? index,
//         name: item[formatIndex.name],
//         categoryId: category.Asfaar_Travel_Speech,
//         personId: person.Hazrat_Aqdas_Molana_Abid_Shah_Sahab_Damat_Barkatuhum,
//         title: item[formatIndex.name],
//         // description: item[formatIndex.description],
//         description: "",
//         place: parent,
//         islamiDate: item[formatIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatIndex.extension],
//         date: item[formatIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       };
//     }));

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// exports.syncDriveFromFreshForHsssBayanAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForHsssBayanAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: category.Speech,
//         personId: person.Hazrat_Aqdas_Sufi_Shamim_Ahmed_Shaikh_Sahab_Rahmatullah_Alaih,
//         title: item[formatIndex.title],
//         name: item[formatIndex.name],
//         title: item[formatIndex.title],
//         description: item[formatIndex.name],
//         place: item[formatIndex.place],
//         islamiDate: item[formatIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatIndex.extension],
//         date: item[formatIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// exports.syncDriveFromFreshForHsssAsfaarAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForHsssAsfaarAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: category.Asfaar_Travel_Speech,
//         personId: person.Hazrat_Aqdas_Sufi_Shamim_Ahmed_Shaikh_Sahab_Rahmatullah_Alaih,
//         title: item[formatIndex.title],
//         name: item[formatIndex.name],
//         title: item[formatIndex.title],
//         description: item[formatIndex.description],
//         place: item[formatIndex.place],
//         islamiDate: item[formatIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatIndex.extension],
//         date: item[formatIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// exports.syncDriveFromFreshForHmasBayanAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForHmasBayanAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: category.Speech,
//         personId: person.Arif_Billah_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Akhtar_Sahab_Rahmatullah_Alaih,
//         title: item[formatIndex.title],
//         name: item[formatIndex.name],
//         title: item[formatIndex.title],
//         description: item[formatIndex.description],
//         place: item[formatIndex.place],
//         islamiDate: item[formatIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatIndex.extension],
//         date: item[formatIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// exports.syncDriveFromFreshForHmasAsfaarAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForHmasAsfaarAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: category.Asfaar_Travel_Speech,
//         personId: person.Haleem_ul_Ummat_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Mazhar_Sahab_Damat_Barkatuhum,
//         title: item[formatIndex.title],
//         name: item[formatIndex.name],
//         title: item[formatIndex.title],
//         description: item[formatIndex.description],
//         place: item[formatIndex.place],
//         islamiDate: item[formatIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatIndex.extension],
//         date: item[formatIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// exports.syncDriveFromFreshForHmmsBayanAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForHmmsBayanAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: category.Speech,
//         personId: person.Haleem_ul_Ummat_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Mazhar_Sahab_Damat_Barkatuhum,
//         title: item[formatIndex.title],
//         name: item[formatIndex.name],
//         title: item[formatIndex.title],
//         description: item[formatIndex.description],
//         place: item[formatIndex.place],
//         islamiDate: item[formatIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatIndex.extension],
//         date: item[formatIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// exports.syncDriveFromFreshForHmmsAsfaarAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForHmmsAsfaarAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: category.Asfaar_Travel_Speech,
//         personId: person.Haleem_ul_Ummat_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Mazhar_Sahab_Damat_Barkatuhum,
//         title: item[formatIndex.title],
//         name: item[formatIndex.name],
//         title: item[formatIndex.title],
//         description: item[formatIndex.description],
//         place: item[formatIndex.place],
//         islamiDate: item[formatIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatIndex.extension],
//         date: item[formatIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// //Ashar
// exports.syncDriveFromFreshForAshaarAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForAshaarAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromAshaarFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: item[formatAshaarIndex.category],
//         personId: item[formatAshaarIndex.person],
//         name: item[formatAshaarIndex.name],
//         title: item[formatAshaarIndex.title],
//         description: item[formatAshaarIndex.description],
//         place: item[formatAshaarIndex.place],
//         islamiDate: item[formatAshaarIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatAshaarIndex.extension],
//         date: item[formatAshaarIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// exports.syncDriveFromFreshForMASSAshaarAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForMASSAshaarAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromAshaarFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: item[formatAshaarIndex.category],
//         personId: person.Molana_Anwar_Sadiq_Sahab_Damat_Barkatuhum,
//         name: item[formatAshaarIndex.name],
//         title: item[formatAshaarIndex.title],
//         description: item[formatAshaarIndex.description],
//         place: item[formatAshaarIndex.place],
//         islamiDate: item[formatAshaarIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatAshaarIndex.extension],
//         date: item[formatAshaarIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// exports.syncDriveFromFreshForMIKSAshaarAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForMIKSAshaarAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromAshaarFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: item[formatAshaarIndex.category],
//         personId: person.Molana_Ibrahim_Kashmiri_Sahab_Damat_Barkatuhum,
//         name: item[formatAshaarIndex.name],
//         title: item[formatAshaarIndex.title],
//         description: item[formatAshaarIndex.description],
//         place: item[formatAshaarIndex.place],
//         islamiDate: item[formatAshaarIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatAshaarIndex.extension],
//         date: item[formatAshaarIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

// exports.syncDriveFromFreshForMQRSAshaarAudio = async (req, res, next) => {
//   try {
//     const files = await GoogleDrive.syncFileByFieldIdsForMQRSAshaarAudio()

//     console.log('MP3 Bayanaat Files:');
//     if (files instanceof Array) {

//     }
//     else {
//       res.send("List empty")
//       return
//     }
//     var entries = [];
//     files.forEach((file, index) => {
//       let item = extractAllFromAshaarFileName(file.name, file.createdTime, file.modifiedTime)
//       let temp = {
//         orignalId: file.id ? file.id : index,
//         categoryId: item[formatAshaarIndex.category],
//         personId: person.Molana_Rashid_Sahab_Damat_Barkatuhum,
//         name: item[formatAshaarIndex.name],
//         title: item[formatAshaarIndex.title],
//         description: item[formatAshaarIndex.description],
//         place: item[formatAshaarIndex.place],
//         islamiDate: item[formatAshaarIndex.islamiDate],
//         viewLink: file.webViewLink,
//         contentLink: file.webContentLink,
//         fileExtension: item[formatAshaarIndex.extension],
//         date: item[formatAshaarIndex.date],
//         createdAt: file.createdTime,
//         updatedAt: file.modifiedTime,
//       }
//       entries.push(temp)
//     });

//     console.log("entries")
//     // console.log(entries)
//     await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })

//     res.send("Insert Successfully")

//   } catch (e) {
//     res.statusCode = 300;
//     console.log(e);
//     res.send({ "message": e.message });
//   }
// };

//for PDFs
exports.syncDriveFromFreshForHmasUrduPdf = async (req, res, next) => {
  try {
    const files = await GoogleDrive.syncFileByFieldIdsForHmasUrduPdf()

    console.log('PDF Hmas Files:');
    if (files instanceof Array) {

    }
    else {
      res.send("List empty")
      return
    }
    var entries = [];
    files.forEach((file, index) => {
      let item = extractAllFromPdfFiles(file.name, file.createdTime, file.modifiedTime)
      let temp = {
        orignalId: file.id ? file.id : index,
        categoryId: category.Urdu_Book,
        personId: person.Arif_Billah_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Akhtar_Sahab_Rahmatullah_Alaih,
        name: item[formatIndexForPdf.name],
        title: item[formatIndexForPdf.title],
        viewLink: file.webViewLink,
        contentLink: file.webContentLink,
        fileExtension: item[formatIndexForPdf.extension],
        iconLink: file.iconLink,
        thumbnailLink: file.thumbnailLink,
        createdAt: file.createdTime,
        updatedAt: file.modifiedTime,
      }
      entries.push(temp)
    });

    console.log("entries")
    // console.log(entries)
    await pdf.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })

    res.send("Insert Successfully")

  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.syncDriveFromFreshForHmasEngPdf = async (req, res, next) => {
  try {
    const files = await GoogleDrive.syncFileByFieldIdsForHmasEngPdf()

    console.log('PDF Files:');
    if (files instanceof Array) {

    }
    else {
      res.send("List empty")
      return
    }
    var entries = [];
    files.forEach((file, index) => {
      let item = extractAllFromPdfFiles(file.name, file.createdTime, file.modifiedTime)
      let temp = {
        orignalId: file.id ? file.id : index,
        categoryId: category.English_Book,
        personId: person.Arif_Billah_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Akhtar_Sahab_Rahmatullah_Alaih,
        name: item[formatIndexForPdf.name],
        title: item[formatIndexForPdf.title],
        viewLink: file.webViewLink,
        contentLink: file.webContentLink,
        fileExtension: item[formatIndexForPdf.extension],
        iconLink: file.iconLink,
        thumbnailLink: file.thumbnailLink,
        createdAt: file.createdTime,
        updatedAt: file.modifiedTime,
      }
      entries.push(temp)
    });

    console.log("entries")
    // console.log(entries)
    await pdf.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })

    res.send("Insert Successfully")

  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.syncDriveFromFreshForHmmsEngPdf = async (req, res, next) => {
  try {
    const files = await GoogleDrive.syncFileByFieldIdsForHmmsEngPdf()

    console.log('PDF Files:');
    if (files instanceof Array) {

    }
    else {
      res.send("List empty")
      return
    }
    var entries = [];
    files.forEach((file, index) => {
      let item = extractAllFromPdfFiles(file.name, file.createdTime, file.modifiedTime)
      let temp = {
        orignalId: file.id ? file.id : index,
        categoryId: category.English_Book,
        personId: person.Haleem_ul_Ummat_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Mazhar_Sahab_Damat_Barkatuhum,
        name: item[formatIndexForPdf.name],
        title: item[formatIndexForPdf.title],
        viewLink: file.webViewLink,
        contentLink: file.webContentLink,
        fileExtension: item[formatIndexForPdf.extension],
        iconLink: file.iconLink,
        thumbnailLink: file.thumbnailLink,
        createdAt: file.createdTime,
        updatedAt: file.modifiedTime,
      }
      entries.push(temp)
    });

    console.log("entries")
    // console.log(entries)
    await pdf.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })

    res.send("Insert Successfully")

  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.syncDriveFromFreshForHmmsUrduPdf = async (req, res, next) => {
  try {
    const files = await GoogleDrive.syncFileByFieldIdsForHmmsUrduPdf()

    console.log('PDF Files:');
    if (files instanceof Array) {

    }
    else {
      res.send("List empty")
      return
    }
    var entries = [];
    files.forEach((file, index) => {
      let item = extractAllFromPdfFiles(file.name, file.createdTime, file.modifiedTime)
      let temp = {
        orignalId: file.id ? file.id : index,
        categoryId: category.Urdu_Book,
        personId: person.Haleem_ul_Ummat_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Mazhar_Sahab_Damat_Barkatuhum,
        name: item[formatIndexForPdf.name],
        title: item[formatIndexForPdf.title],
        viewLink: file.webViewLink,
        contentLink: file.webContentLink,
        fileExtension: item[formatIndexForPdf.extension],
        iconLink: file.iconLink,
        thumbnailLink: file.thumbnailLink,
        createdAt: file.createdTime,
        updatedAt: file.modifiedTime,
      }
      entries.push(temp)
    });

    console.log("entries")
    // console.log(entries)
    await pdf.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })

    res.send("Insert Successfully")

  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

//for Short Videos
exports.syncDriveFromFreshForHmasShortVideo = async (req, res, next) => {
  try {
    const files = await GoogleDrive.syncFileByFieldIdsForHmasShortVideo()

    console.log('PDF Files:');
    if (files instanceof Array) {

    }
    else {
      res.send("List empty")
      return
    }
    var entries = [];
    files.forEach((file, index) => {
      let item = extractAllFromShortVideoFiles(file.name, file.createdTime, file.modifiedTime)
      let temp = {
        orignalId: file.id ? file.id : index,
        categoryId: category.Short_Video,
        personId: person.Arif_Billah_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Akhtar_Sahab_Rahmatullah_Alaih,
        name: item[formatIndexForShortVideo.name],
        title: item[formatIndexForShortVideo.title],
        viewLink: file.webViewLink,
        contentLink: file.webContentLink,
        fileExtension: item[formatIndexForShortVideo.extension],
        iconLink: file.iconLink,
        thumbnailLink: file.thumbnailLink,
        createdAt: file.createdTime,
        updatedAt: file.modifiedTime,
      }
      entries.push(temp)
    });

    console.log("entries")
    // console.log(entries)
    await video.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })

    res.send("Insert Successfully")

  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.syncDriveFromFreshForMasbShortVideo = async (req, res, next) => {
  try {
    const files = await GoogleDrive.syncFileByFieldIdsForMasbShortVideo()

    console.log('PDF Files:');
    if (files instanceof Array) {

    }
    else {
      res.send("List empty")
      return
    }
    var entries = [];
    files.forEach((file, index) => {
      let item = extractAllFromPdfFiles(file.name, file.createdTime, file.modifiedTime)
      let temp = {
        orignalId: file.id ? file.id : index,
        categoryId: category.Short_Video,
        personId: person.Hazrat_Aqdas_Molana_Abid_Shah_Sahab_Damat_Barkatuhum,
        name: item[formatIndexForShortVideo.name],
        title: item[formatIndexForShortVideo.title],
        viewLink: file.webViewLink,
        contentLink: file.webContentLink,
        fileExtension: item[formatIndexForShortVideo.extension],
        iconLink: file.iconLink,
        thumbnailLink: file.thumbnailLink,
        createdAt: file.createdTime,
        updatedAt: file.modifiedTime,
      }
      entries.push(temp)
    });

    console.log("entries")
    // console.log(entries)
    await video.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })

    res.send("Insert Successfully")

  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

// For thumbnail
exports.syncDriveFromFreshForThumbnail = async (req, res, next) => {
  try {
    const FilesIds = [...driveBookIdsForSync, ...driveVideoIdsForSync];
    let errors = [];

    for (const fileItem of FilesIds) {
      const files = await GoogleDrive.syncFileByFieldIdsForThumbnail(fileItem.id);
      const __dirname = path.resolve();

      // Wait for all downloads in this folder
      await Promise.all(
        files.map(async (file, index) => {
          try {
            let name = file.id + ".jpg";

            const filePath = path.join(__dirname, "uploads", name);

            if (!checkFileExists(filePath)) {
              await downloadImageToUrl(file.thumbnailLink, filePath);
            }
          } catch (err) {
            console.error("❌ Error downloading:", err.message);
            errors.push({ fileId: file.id, error: err.message });
          }
        })
      );
    }

    // ✅ Response tab milega jab saara kaam complete ho jae
    res.status(200).send({
      message: "Download finished",
      errorCount: errors.length,
      errors,
    });
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ message: e.message });
  }
};

const checkFileExists = (filePath) => {
  if (fs.existsSync(filePath)) {
    console.log("✅ File exists:", filePath);
    return true;
  } else {
    return false;
  }
};

const downloadImageToUrl = (url, savePath) => {
  return new Promise((resolve, reject) => {
    const file = fs.createWriteStream(savePath);

    https
      .get(url, (response) => {
        if (response.statusCode !== 200) {
          reject(new Error(`Failed to download: ${response.statusCode}`));
          return;
        }

        response.pipe(file);
        file.on("finish", () => {
          file.close();
          console.log(`✅ Downloaded: ${savePath}`);
          resolve(savePath);
        });
      })
      .on("error", (err) => {
        fs.unlink(savePath, () => {}); // cleanup if failed
        reject(err);
      });
  });
};

// //End thumbnail work


exports.getByLimit = async (req, res, next) => {
  try {
    const { offset, limit } = req.body;
    const data = await News.findAndCountAll({
      offset: offset,
      limit: limit,
      where: { deletedAt: null }
    });
    res.send(data)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.getAll = async (req, res, next) => {
  try {
    const data = await News.findAll({
      where: { deletedAt: null }
    });
    res.send(data)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.getById = async (req, res, next) => {
  try {
    const { id } = req.params;
    const data = await News.findOne({ where: { id: id, deletedAt: null } });
    res.send(data)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.update = async (req, res, next) => {
  try {
    const { id } = req.params;
    const result = await News.update(req.body, { where: { id: id, deletedAt: null } });
    res.send(result == 1 ? true : false);
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "messagaae": e.message });
  }
};

exports.delete = async (req, res, next) => {
  try {
    const { id } = req.params;
    const result = await News.destroy({ where: { id: id } });
    res.send(result == 1 ? true : false);
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};


//sync data for All Ashaar ids 
exports.syncDriveFromFreshForAllAshaar = async (req, res, next) => {
  try {
    const FilesIds = drivePoetryIdsForSync;
    let errors = [];

    for (const fileItem of FilesIds) {
      let id = fileItem.id;
      let categoryId = fileItem.category;
      let personId = fileItem.person;

      let files = [];
      try {
        files = await GoogleDrive.syncFileByFileIdWithSubFolder(id);

        if (!(files instanceof Array) || files.length === 0) {
          errors.push({ id, error: "No files found" });
          continue; // skip this ID, go to next
        }
      } catch (err) {
        console.error(`❌ Error while syncing files for id ${id}:`, err.message);
        errors.push({ id, error: err.message });
        continue; // skip this ID, go to next
      }

      // process files if ok
      let entries = await Promise.all(
        files.map(async (file, index) => {
          let parent = {};
          try {
            parent = await GoogleDrive.syncParentFolderName(file.id);
          } catch (err) {
            console.error(`Error getting parent for file ${file.id}:`, err.message);
          }

          let fileName = file.name ?? "Unknown";
          let item = extractAllFromAshaarFileName(fileName, file.createdTime, file.modifiedTime)
          let array = extractDescriptionFromTitle(item[formatAshaarIndex.title])

          return {
            orignalId: file.id ?? index,
            name: fileName,
            categoryId,
            personId,
            title: array[formatIndexForDescription.title],
            description: array[formatIndexForDescription.description],
            place: "From: " + (parent.name || "Unknown"),
            islamiDate: file.modifiedTime,
            viewLink: file.webViewLink,
            contentLink: file.webContentLink,
            fileExtension: item[formatAshaarIndex.extension],
            date: item[formatAshaarIndex.date],
            createdAt: file.createdTime,
            updatedAt: file.modifiedTime,
          };
        })
      );

      // console.log("entries")
      // console.log(entries)

      await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })
    }

    // ✅ Final response after processing all IDs
    res.status(200).send({
      message: "Sync finished",
      errorCount: errors.length,
      errors,
    });

  } catch (e) {
    console.error(e);
    res.status(500).send({ message: e.message });
  }
};

//Asfaar bayanaat
exports.syncDriveFromFreshForAllAsfaarBayanaat = async (req, res, next) => {
  try {
    const FilesIds = driveAsfaarBayanaatIdsForSync;
    let errors = [];

    for (const fileItem of FilesIds) {
      var id = fileItem.id;
      var categoryId = fileItem.category;
      var personId = fileItem.person;

      let files = [];

      try {
        files = await GoogleDrive.syncFileByFileIdWithSubFolder(id);

        if (!(files instanceof Array) || files.length === 0) {
          errors.push({ id, error: "No files found" });
          continue; // skip this ID, go to next
        }
      } catch (err) {
        console.error(`❌ Error while syncing files for id ${id}:`, err.message);
        errors.push({ id, error: err.message });
        continue; // skip this ID, go to next
      }

      var groupList = [];

      let entries = await Promise.all(files.map(async (file, index) => {

        var parent = null;
        try {
          parent = await GoogleDrive.syncParentFolderName(file.id);
        } catch (err) {
          console.error(`Error getting parent for file ${file.id}:`, err.message);
          parent = {}; // fallback value
        }

        groupList.push({
          orignalId: parent.id,
          title: parent.name,
          categoryId,
          personId,
          date: Date(),
          createdAt: Date(),
          updatedAt: Date(),
        });

        let fileName = file.name ?? "Unknown";
        let item = extractAllFromFileName(fileName, file.createdTime, file.modifiedTime)
        let array = extractDescriptionFromTitle(item[formatIndex.title])

        return {
          orignalId: file.id ?? index,
          name: fileName,
          categoryId: categoryId,
          personId: personId,
          title: array[formatIndexForDescription.title],
          description: array[formatIndexForDescription.description],
          place: 'From: ' + (parent.name || "Unknown"),
          islamiDate: file.createdTime,
          viewLink: file.webViewLink,
          contentLink: file.webContentLink,
          fileExtension: item[formatIndex.extension],
          date: item[formatIndex.date],
          createdAt: file.createdTime,
          updatedAt: file.modifiedTime,
        };
      }));

      // console.log("entries")
      // console.log(entries)

      //filer
      groupList = groupList.filter(
        (v, i, a) =>
          v.orignalId !== id && // exclude same id
          a.findIndex(t => t.orignalId === v.orignalId) === i // keep unique
      );

             // only if array still has elements
      if (groupList.length > 0) {
          // console.log(groupList);
          await Group.bulkCreate(groupList, { updateOnDuplicate: ["orignalId", "title", "date", "createdAt", "updatedAt"] })
      }

      await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })
    }

    // ✅ Final response after processing all IDs
    res.status(200).send({
      message: "Sync finished",
      errorCount: errors.length,
      errors,
    });

  } catch (e) {
    console.error(e);
    res.status(500).send({ message: e.message });
  }
};

// All book
exports.syncDriveFromFreshForAllBook = async (req, res, next) => {

  try {
    const FilesIds = driveBookIdsForSync;
    let errors = [];

    for (const fileItem of FilesIds) {
      var id = fileItem.id;
      var categoryId = fileItem.category;
      var personId = fileItem.person;

      let files = [];

      try {
        files = await GoogleDrive.syncFileByFieldIdForBook(id);

        if (!(files instanceof Array) || files.length === 0) {
          errors.push({ id, error: "No files found" });
          continue; // skip this ID, go to next
        }
      } catch (err) {
        console.error(`❌ Error while syncing files for id ${id}:`, err.message);
        errors.push({ id, error: err.message });
        continue; // skip this ID, go to next
      }

      var entries = [];
      files.forEach((file, index) => {
        let item = extractAllFromPdfFiles(file.name, file.createdTime, file.modifiedTime)
        let temp = {
          orignalId: file.id ? file.id : index,
          categoryId,
          personId,
          name: file.name,
          title: item[formatIndexForPdf.title],
          viewLink: file.webViewLink,
          contentLink: file.webContentLink,
          fileExtension: item[formatIndexForPdf.extension],
          iconLink: file.iconLink,
          thumbnailLink: file.thumbnailLink,
          createdAt: file.createdTime,
          updatedAt: file.modifiedTime,
        }
        entries.push(temp)
      });

      // console.log("entries")
      // console.log(entries)

      await pdf.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })
    }

    // ✅ Final response after processing all IDs
    res.status(200).send({
      message: "Sync finished",
      errorCount: errors.length,
      errors,
    });

  } catch (e) {
    console.error(e);
    res.status(500).send({ message: e.message });
  }
};

//All Videos
exports.syncDriveFromFreshForAllVideo = async (req, res, next) => {

  try {
    const FilesIds = driveVideoIdsForSync;
    let errors = [];

    for (const fileItem of FilesIds) {
      var id = fileItem.id;
      var categoryId = fileItem.category;
      var personId = fileItem.person;

      let files = [];

      try {
        files = await GoogleDrive.syncFileByFieldIdForAllVideo(id);

        if (!(files instanceof Array) || files.length === 0) {
          errors.push({ id, error: "No files found" });
          continue; // skip this ID, go to next
        }
      } catch (err) {
        console.error(`❌ Error while syncing files for id ${id}:`, err.message);
        errors.push({ id, error: err.message });
        continue; // skip this ID, go to next
      }

      var entries = [];
      files.forEach((file, index) => {
        let item = extractAllFromShortVideoFiles(file.name, file.createdTime, file.modifiedTime)
        let temp = {
          orignalId: file.id ? file.id : index,
          categoryId,
          personId,
          name: file.name,
          title: item[formatIndexForShortVideo.title],
          viewLink: file.webViewLink,
          contentLink: file.webContentLink,
          fileExtension: item[formatIndexForShortVideo.extension],
          iconLink: file.iconLink,
          thumbnailLink: file.thumbnailLink,
          createdAt: file.createdTime,
          updatedAt: file.modifiedTime,
        }
        entries.push(temp)
      });

      // console.log("entries")
      // console.log(entries)

      await video.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "islamiDate", "viewLink", "contentLink", "iconLink", "thumbnailLink", "fileExtension", "createdAt", "updatedAt"] })
    }

      // ✅ Final response after processing all IDs
    res.status(200).send({
      message: "Sync finished",
      errorCount: errors.length,
      errors,
    });

  } catch (e) {
    console.error(e);
    res.status(500).send({ message: e.message });
  }
};

//Molana Abid Shah SB bayanaat
exports.syncDriveFromFreshForAllMASSBayanaat = async (req, res, next) => {
  try {
    const FilesIds = driveBayanaatMASSIdsForSync;
    let errors = [];

    for (const fileItem of FilesIds) {
      var id = fileItem.id;
      var categoryId = fileItem.category;
      var personId = fileItem.person;

      let files = [];

      try {
        files = await GoogleDrive.syncFileByFileIdWithSubFolder(id);

        if (!(files instanceof Array) || files.length === 0) {
          errors.push({ id, error: "No files found" });
          continue; // skip this ID, go to next
        }
      } catch (err) {
        console.error(`❌ Error while syncing files for id ${id}:`, err.message);
        errors.push({ id, error: err.message });
        continue; // skip this ID, go to next
      }

      var groupList = [];

      let entries = await Promise.all(files.map(async (file, index) => {

        var parent = null;
        try {
          parent = await GoogleDrive.syncParentFolderName(file.id);
        } catch (err) {
          console.error(`Error getting parent for file ${file.id}:`, err.message);
          parent = {}; // fallback value
        }

        groupList.push({
          orignalId: parent.id,
          title: parent.name,
          categoryId,
          personId,
          date: Date(),
          createdAt: Date(),
          updatedAt: Date(),
        });

        let fileName = file.name ?? "Unknown";
        let item = extractAllFromFileMASSSpeech(fileName, file.createdTime)

        let array = extractDescriptionFromTitle(item[formatIndexMASSSpeech.title])

        return {
          orignalId: file.id ?? index,
          name: fileName,
          categoryId: categoryId,
          personId: personId,
          title: array[formatIndexForDescription.title],
          description: array[formatIndexForDescription.description],
          place: 'From: ' + (parent.name || "Unknown"),
          islamiDate: file.createdTime,
          viewLink: file.webViewLink,
          contentLink: file.webContentLink,
          fileExtension: item[formatIndexMASSSpeech.extension],
          date: item[formatIndexMASSSpeech.date],
          createdAt: file.createdTime,
          updatedAt: file.modifiedTime,
        };
      }));

      // console.log("entries")
      // console.log(entries)

      //filer
      groupList = groupList.filter(
        (v, i, a) =>
          v.orignalId !== id && // exclude same id
          a.findIndex(t => t.orignalId === v.orignalId) === i // keep unique
      );

            // only if array still has elements
      if (groupList.length > 0) {
          // console.log(groupList);
          await Group.bulkCreate(groupList, { updateOnDuplicate: ["orignalId", "title", "date", "createdAt", "updatedAt"] })
      }

      await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })
    }

    // ✅ Final response after processing all IDs
    res.status(200).send({
      message: "Sync finished",
      errorCount: errors.length,
      errors,
    });

  } catch (e) {
    console.error(e);
    res.status(500).send({ message: e.message });
  }
};

//All bayanaat
exports.syncDriveFromFreshForAllBayanaat = async (req, res, next) => {
  try {
    const FilesIds = driveBayanaatIdsForSync;
    let errors = [];

    for (const fileItem of FilesIds) {
      var id = fileItem.id;
      var categoryId = fileItem.category;
      var personId = fileItem.person;

      let files = [];

      try {
        files = await GoogleDrive.syncFileByFileIdWithSubFolder(id);

        if (!(files instanceof Array) || files.length === 0) {
          errors.push({ id, error: "No files found" });
          continue; // skip this ID, go to next
        }
      } catch (err) {
        console.error(`❌ Error while syncing files for id ${id}:`, err.message);
        errors.push({ id, error: err.message });
        continue; // skip this ID, go to next
      }

      var groupList = [];

      let entries = await Promise.all(files.map(async (file, index) => {

        var parent = null;
        try {
          parent = await GoogleDrive.syncParentFolderName(file.id);
        } catch (err) {
          console.error(`Error getting parent for file ${file.id}:`, err.message);
          parent = {}; // fallback value
        }

        groupList.push({
          orignalId: parent.id,
          title: parent.name,
          categoryId,
          personId,
          date: Date(),
          createdAt: Date(),
          updatedAt: Date(),
        });

        let fileName = file.name ?? "Unknown";
        let item = extractAllFromFileName(fileName, file.createdTime)
         let array = extractDescriptionFromTitle(item[formatIndex.title])

        return {
          orignalId: file.id ?? index,
          name: fileName,
          categoryId: categoryId,
          personId: personId,
          title: array[formatIndexForDescription.title],
          description: array[formatIndexForDescription.description],
          place: 'From: ' + (parent.name || "Unknown"),
          islamiDate: file.createdTime,
          viewLink: file.webViewLink,
          contentLink: file.webContentLink,
          fileExtension: item[formatIndex.extension],
          date: item[formatIndex.date],
          createdAt: file.createdTime,
          updatedAt: file.modifiedTime,
        };
      }));

      // console.log("entries")
      // console.log(entries)

      //filer
      groupList = groupList.filter(
        (v, i, a) =>
          v.orignalId !== id && // exclude same id
          a.findIndex(t => t.orignalId === v.orignalId) === i // keep unique
      );

      // only if array still has elements
      if (groupList.length > 0) {
          // console.log(groupList);
          await Group.bulkCreate(groupList, { updateOnDuplicate: ["orignalId", "title", "date", "createdAt", "updatedAt"] })
      }

      await Audio.bulkCreate(entries, { updateOnDuplicate: ["orignalId", "name", "title", "description", "place", "islamiDate", "viewLink", "contentLink", "fileExtension", "date", "createdAt", "updatedAt"] })
    }

    // ✅ Final response after processing all IDs
    res.status(200).send({
      message: "Sync finished",
      errorCount: errors.length,
      errors,
    });

  } catch (e) {
    console.error(e);
    res.status(500).send({ message: e.message });
  }
};