const fs = require('fs').promises;
const path = require('path');
const process = require('process');
const {google} = require('googleapis');

const TOKEN_PATH = path.join(process.cwd(), 'GoogleDrive/token.json');

const clientId = process.env.GOOGLE_DRIVE_CLIENT_ID;
const clientSecret = process.env.GOOGLE_DRIVE_CLIENT_SECRET;
const redirectUri = process.env.GOOGLE_DRIVE_REDIRECT_URI;

const oAuth2Client = new google.auth.OAuth2(clientId, clientSecret, redirectUri);

// try {
//   const content = fs.readFile(TOKEN_PATH);
//   const credentials = JSON.parse(content);
//   oAuth2Client.setCredentials(credentials);
// } catch (err) {
//   console.log("No Credentials found")
// }

// Generate the authentication URL
exports.authorizeGoogleAuth = async () => {
  const url = await oAuth2Client.generateAuthUrl({
    access_type: "offline",
    scope: [
      'https://www.googleapis.com/auth/drive',
    ],
  });
  return url;
};

exports.setAuthCallback = async (code) => {
  const { tokens } = await oAuth2Client.getToken(code);

  const accessToken = tokens.access_token;
  const refreshToken = tokens.refresh_token;

  if(refreshToken == undefined){
    return
  }
  oAuth2Client.setCredentials({ refresh_token: refreshToken, access_token:accessToken });

  const payload = JSON.stringify({
    type: 'authorized_user',
    client_id: clientId,
    client_secret: clientSecret,
    refresh_token: refreshToken,
  });
  
  fs.writeFile(TOKEN_PATH, payload);
};