'use strict';

const { personNameShortForm, person } = require("../constants/dbConstants");

module.exports = {
  up: async (queryInterface, Sequelize) => {
    return queryInterface.bulkInsert('person', [
      {
        id: person.Arif_Billah_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Akhtar_Sahab_Rahmatullah_Alaih,
        title: personNameShortForm.HMAS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: person.Haleem_ul_Ummat_Hazrat_Aqdas_Molana_Shah_Hakeem_Muhammad_Mazhar_Sahab_Damat_Barkatuhum,
        title: personNameShortForm.HMMS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: person.Hazrat_Aqdas_Sufi_Shamim_Ahmed_Shaikh_Sahab_Rahmatullah_Alaih,
        title: personNameShortForm.HSSS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: person.Hazrat_Aqdas_Molana_Abid_Shah_Sahab_Damat_Barkatuhum,
        title: personNameShortForm.MASB,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: person.Molana_Anwar_Sadiq_Sahab_Damat_Barkatuhum,
        title: personNameShortForm.MASS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: person.Molana_Rashid_Sahab_Damat_Barkatuhum,
        title: personNameShortForm.MQRS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: person.Molana_Ibrahim_Kashmiri_Sahab_Damat_Barkatuhum,
        title: personNameShortForm.MIKS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: person.Hafiz_Bilal_Bhai,
        title: personNameShortForm.HBB,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: person.Hazrat_Taib_SB,
        title: personNameShortForm.HTS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: person.Hakeem_ul_Ummat_Hazrat_Molana_Ashraf_Ali_Thanvi_SB_RA,
        title: personNameShortForm.AATS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
  ]);
  },

  down: async (queryInterface, Sequelize) => {
    return queryInterface.bulkDelete('person', null, {});
  }
};
