'use strict';
const { categoryNameShortForm, type, category } = require("../constants/dbConstants");

module.exports = {
  up: async (queryInterface, Sequelize) => {
    return queryInterface.bulkInsert('category', [
      {
        id: category.Poetry,
        typeId: type.Poetry,
        title: categoryNameShortForm.PO,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: category.Poetry_With_Explanation_Tashreeh,
        typeId: type.Poetry,
        title: categoryNameShortForm.PWE,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: category.Video,
        typeId: type.Video,
        title: categoryNameShortForm.VI,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: category.Short_Speech,
        typeId: type.Speech,
        title: categoryNameShortForm.SS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: category.Asfaar_Travel_Speech,
        typeId: type.Speech,
        title: categoryNameShortForm.AS,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: category.Speech,
        typeId: type.Speech,
        title: categoryNameShortForm.SP,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: category.Dhikr,
        typeId: type.Dhikr,
        title: categoryNameShortForm.DH,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: category.English_Book,
        typeId: type.Book,
        title: categoryNameShortForm.EB,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: category.Urdu_Book,
        typeId: type.Book,
        title: categoryNameShortForm.UB,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: category.Short_Video,
        typeId: type.Video,
        title: categoryNameShortForm.SV,
        createdAt: new Date(),
        updatedAt: new Date()
      },
  ]);
  },

  down: async (queryInterface, Sequelize) => {
    return queryInterface.bulkDelete('category', null, {});
  }
};
