const Group = require("../../database/models/group");
const Category = require("../../database/models/category");
const Type = require("../../database/models/type");
const Person = require("../../database/models/person");

exports.post = async (req, res, next) => {
  try {
    await Group.create(req.body);
    res.send("Insert Successfully")
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.getByLimit = async (req, res, next) => {
  try {
    const { offset, limit } = req.body;
    const data = await Group.findAndCountAll({
      offset: offset,
      limit: limit,
      where: { deletedAt: null }
    });
    res.send(data)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.getAll = async (req, res, next) => {
  try {
    const data = await Group.findAll({
      where: { deletedAt: null }
    });
    res.send(data)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.getAllByPersonAndCategory = async (req, res, next) => {
   const { categoryId, personId } = req.body;
  try {
    const data = await Group.findAll({
      where:{personId: personId, categoryId: categoryId , deletedAt: null},
      include:[
        {
          model: Person,
          as: "person"
        },
        {
          model: Category,
          as: "category",
        }
      ]
    });
    res.send(data)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.getAllByTypeAndPersonAndCategory = async (req, res, next) => {
   const { typeId, categoryId, personId } = req.body;
  try {
    const data = await Group.findAll({
      where:{personId: personId, categoryId: categoryId , deletedAt: null},
      include:[
        {
          model: Person,
          as: "person"
        },
        {
          model: Category,
          as: "category",
           where:{typeId: typeId},
          include:{
            model: Type,
            as: "type"
          }
        }
      ]
    });
    res.send(data)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.getById = async (req, res, next) => {
  try {
    const { id } = req.params;
    const data = await Group.findOne({ where: { id: id, deletedAt: null } });
    res.send(data)
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

exports.update = async (req, res, next) => {
  try {
    const { id } = req.params;
    const result = await Group.update(req.body, { where: { id: id, deletedAt: null } });
    res.send(result == 1 ? true : false);
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "messagaae": e.message });
  }
};

exports.delete = async (req, res, next) => {
  try {
    const { id } = req.params;
    const result = await Group.destroy({ where: { id: id } });
    res.send(result == 1 ? true : false);
  } catch (e) {
    res.statusCode = 300;
    console.log(e);
    res.send({ "message": e.message });
  }
};

