const dbConstants = require("../../constants/dbConstants.js");

exports.extractAllFromFileMASSSpeech = (name, createdAt) => {
    let array = ["", "", ""]; //date$$title$$extension
    let tempArray = name.split('.');
    let title = tempArray[0];
    let dateRegix = /^(?:(?:31(\/|-|\.)(?:0?[13578]|1[02]))\1|(?:(?:29|30)(\/|-|\.)(?:0?[13-9]|1[0-2])\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})$|^(?:29(\/|-|\.)0?2\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:0?[1-9]|1\d|2[0-8])(\/|-|\.)(?:(?:0?[1-9])|(?:1[0-2]))\4(?:(?:1[6-9]|[2-9]\d)?\d{2})$/
    let splitTile = title.split(' ');
    let firstElement = splitTile[0];
    let lastElement = splitTile[splitTile.length - 1];

    array[this.formatIndexMASSSpeech.extension] = tempArray[tempArray.length - 1];

    // 20-5-2022.mp3
    // 5-12-2020 night mjlis.mp3
    if (dateRegix.test(firstElement)) {

        let dateArray = firstElement.split('-');
        var year = dateArray[2];
        if (year.length == 2) {
            year = "20" + year;
        }
        let dateString = `${dateArray[0]}-${dateArray[1]}-${year}`;
        let nameOnly = splitTile.slice(1).join(" "); // "My Audio File"
        // regex for DD-MM-YYYY or D-M-YYYY
        const isDate = /^\d{1,2}-\d{1,2}-\d{4}$/.test(dateString);
        if (isDate) {
            if (typeof nameOnly === "string" && nameOnly.trim() !== "") {
                array[this.formatIndexMASSSpeech.title] = nameOnly
            } else {
                const fullDate = new Date(`${year}-${dateArray[1]}-${dateArray[0]}`);
                const day = fullDate.getDay();

                let dayString = this.dayNames[day]

                if (this.dayNames.includes(dayString)) {
                    array[this.formatIndexMASSSpeech.title] = `${dayString} Majlis`
                } else {
                    array[this.formatIndexMASSSpeech.title] = 'Majlis'
                }
            }


            array[this.formatIndexMASSSpeech.date] = dateString
        }
        else {
            array[this.formatIndexMASSSpeech.title] = title
            array[this.formatIndexMASSSpeech.date] = createdAt
        }

        return array;
    }
    else if (dateRegix.test(lastElement)) {
        // 'Mahy Mohorrum k Aamal part 3  18-9-18.mp3'

        let dateArray = lastElement.split('-');
        var year = dateArray[2];
        if (year.length == 2) {
            year = "20" + year;
        }
        let dateString = `${dateArray[0]}-${dateArray[1]}-${year}`;
        let nameOnly = splitTile.slice(0, -1).join(" "); // "My Audio File"
        // regex for DD-MM-YYYY or D-M-YYYY
        const isDate = /^\d{1,2}-\d{1,2}-\d{4}$/.test(dateString);
        if (isDate) {
            array[this.formatIndexMASSSpeech.title] = nameOnly
            array[this.formatIndexMASSSpeech.date] = dateString
        }
        else {
            array[this.formatIndexMASSSpeech.title] = title
            array[this.formatIndexMASSSpeech.date] = createdAt
        }

        return array;
    }
    else {
        let recTileArray = firstElement.split('-');
        var recTile = recTileArray[0];
        if (recTile.includes("rec")) {
            // rec1225-143934.mp3
            recTile = recTile.replace("rec", "");
            let recDateRegix = /^(\w{4})$/
            if (recDateRegix.test(recTile)) {
                let month = recTile.substring(0, 2);
                let date = recTile.substring(2, 4);

                let createdDate = new Date(createdAt);
                let year = createdDate.getFullYear();

                let dateString = `${date}-${month}-${year}`;
                array[this.formatIndexMASSSpeech.date] = dateString

                const fullDate = new Date(`${year}-${month}-${date}`);
                if (fullDate instanceof Date) {
                    const day = fullDate.getDay();
                    array[this.formatIndexMASSSpeech.title] = `${this.dayNames[day]} Majlis`
                    return array;
                }
            }
        }
        else {
            // 2022-10-04 19-11-58.mp3
            // 2022-08-23 Ashar Tashree, by parda haseeno sy khabi dil na laga.mp3

            // step 2: split by space
            let nameParts = title.split(" "); // ["123", "My", "Audio", "File"]
            // step 3: merge except first element
            let nameOnly = nameParts.slice(1).join(" "); // "My Audio File"
            let firstElement = nameParts[0]; // "2022-08-23"
            // simple regex check for YYYY-MM-DD
            let isDate = /^\d{4}-\d{1,2}-\d{1,2}$/.test(firstElement);

            if (isDate) {
                array[this.formatIndexMASSSpeech.title] = nameOnly
                array[this.formatIndexMASSSpeech.date] = firstElement
            }
            else {
                array[this.formatIndexMASSSpeech.title] = title
                array[this.formatIndexMASSSpeech.date] = createdAt
            }
            return array;
        }
    }
    // 13_11_2020.mp3
    let dateArr = title.split('_');
    if (dateArr.length > 1) {
        var year = dateArr[2];
        if (year.length == 2) {
            year = "20" + year;
        }
        let dateString = `${dateArr[0]}-${dateArr[1]}-${year}`;

        let isDate = /^\d{4}-\d{1,2}-\d{1,2}$/.test(dateString);

        if (isDate) {
            array[this.formatIndexMASSSpeech.date] = dateString
        }
        else {
            array[this.formatIndexMASSSpeech.date] = createdAt
        }


        const fullDate = new Date(`${year}-${dateArr[1]}-${dateArr[0]}`);
        const day = fullDate.getDay();

        let dayString = this.dayNames[day]

        if (this.dayNames.includes(dayString)) {
            array[this.formatIndexMASSSpeech.title] = `${dayString} Majlis`
        } else {
            array[this.formatIndexMASSSpeech.title] = title
        }

        return array;
    }

    // 13 11 2020.mp3
    let dateArrSpace = title.split(' ');
    if (dateArrSpace.length > 1) {
        var year = dateArrSpace[2];
        let dateString = `${dateArrSpace[0]}-${dateArrSpace[1]}-${year}`;
        let iDate = /^\d{4}-\d{1,2}-\d{1,2}$/.test(dateString);

        if (iDate) {
            array[this.formatIndexMASSSpeech.date] = dateString
            const fullDate = new Date(`${year}-${dateArrSpace[1]}-${dateArrSpace[0]}`);
            const day = fullDate.getDay();

            let dayString = this.dayNames[day]

            if (this.dayNames.includes(dayString)) {
                array[this.formatIndex.title] = `${dayString} Majlis`
            } else {
                array[this.formatIndex.title] = title
            }

            array[this.formatIndexMASSSpeech.title] = `${this.dayNames[day]} Majlis`
        }
        else {
            array[this.formatIndexMASSSpeech.date] = createdAt
            array[this.formatIndexMASSSpeech.title] = title
        }


        return array;
    }

}

exports.extractDescriptionFromTitle = (title) => {
  let array = ["", ""]; // [title, description]

  // Match text before and inside brackets
  const match = title.match(/^(.*?)\s*\((.*?)\)\s*$/);

  if (match) {
    array[this.formatIndexForDescription.title] = match[1].trim(); // Title (before brackets)
    array[this.formatIndexForDescription.description] = match[2].trim(); // Description (inside brackets)
  } else {
    array[this.formatIndexForDescription.title] = title.trim(); // No brackets found
    array[this.formatIndexForDescription.description] = "";
  }

  return array;
};

exports.extractAllFromFileName = (name, createdAt, updatedAt) => {
    let array = ["", "", ""]; //date$$title$$extension
    let tempArray = name.split('.');
    let title = tempArray[0];
    let dateRegix = /^(?:(?:31(\/|-|\.)(?:0?[13578]|1[02]))\1|(?:(?:29|30)(\/|-|\.)(?:0?[13-9]|1[0-2])\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})$|^(?:29(\/|-|\.)0?2\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:0?[1-9]|1\d|2[0-8])(\/|-|\.)(?:(?:0?[1-9])|(?:1[0-2]))\4(?:(?:1[6-9]|[2-9]\d)?\d{2})$/
    let splitTile = title.split(' ');
    let firstElement = splitTile[0];
    let lastElement = splitTile[splitTile.length - 1];

    array[this.formatIndex.extension] = tempArray[tempArray.length - 1];

    // 20-5-2022.mp3
    // 5-12-2020 night mjlis.mp3
    if (dateRegix.test(firstElement)) {
        array[this.formatIndex.date] = firstElement
        let dateArray = firstElement.split('-');
        var year = dateArray[2];
        if (year.length == 2) {
            year = "20" + year;
        }
        let dateString = `${dateArray[0]}-${dateArray[1]}-${year}`;

        let nameOnly = splitTile.slice(1).join(" "); // "My Audio File"
        // regex for DD-MM-YYYY or D-M-YYYY
        const isDate = /^\d{1,2}-\d{1,2}-\d{4}$/.test(dateString);
        if (isDate) {

            if (typeof nameOnly === "string" && nameOnly.trim() !== "") {
                array[this.formatIndexMASSSpeech.title] = nameOnly
            } else {
                const fullDate = new Date(`${year}-${dateArray[1]}-${dateArray[0]}`);
                const day = fullDate.getDay();

                let dayString = this.dayNames[day]

                if (this.dayNames.includes(dayString)) {
                    array[this.formatIndex.title] = `${dayString} Majlis`
                } else {
                    array[this.formatIndex.title] = 'Majlis'
                }
            }

            array[this.formatIndex.date] = dateString
        }
        else {
            array[this.formatIndex.title] = title
            array[this.formatIndex.date] = createdAt
        }

        return array;
    }
    else if (dateRegix.test(lastElement)) {
        // 'Mahy Mohorrum k Aamal part 3  18-9-18.mp3'

        let dateArray = lastElement.split('-');
        var year = dateArray[2];
        if (year.length == 2) {
            year = "20" + year;
        }
        let dateString = `${dateArray[0]}-${dateArray[1]}-${year}`;
        let nameOnly = splitTile.slice(0, -1).join(" "); // "My Audio File"
        // regex for DD-MM-YYYY or D-M-YYYY
        const isDate = /^\d{1,2}-\d{1,2}-\d{4}$/.test(dateString);
        if (isDate) {
            array[this.formatIndexMASSSpeech.title] = nameOnly
            array[this.formatIndexMASSSpeech.date] = dateString
        }
        else {
            array[this.formatIndexMASSSpeech.title] = title
            array[this.formatIndexMASSSpeech.date] = createdAt
        }

        return array;
    }
    else {
        let recTileArray = firstElement.split('-');
        var recTile = recTileArray[0];
        if (recTile.includes("rec")) {
            // rec1225-143934.mp3
            recTile = recTile.replace("rec", "");
            let recDateRegix = /^(\w{4})$/
            if (recDateRegix.test(recTile)) {
                let month = recTile.substring(0, 2);
                let date = recTile.substring(2, 4);

                let createdDate = new Date(createdAt);
                let year = createdDate.getFullYear();

                let dateString = `${date}-${month}-${year}`;
                let isDate = /^\d{4}-\d{1,2}-\d{1,2}$/.test(dateString);

                if (isDate) {
                    array[this.formatIndex.date] = dateString
                }
                else {
                    array[this.formatIndex.date] = createdAt
                }


                const fullDate = new Date(`${year}-${month}-${date}`);
                if (fullDate instanceof Date) {
                    const day = fullDate.getDay();
                    array[this.formatIndex.title] = `${this.dayNames[day]} Majlis`
                    return array;
                }
            }
        }
        else {
            // 2022-10-04 19-11-58.mp3
            // 2022-08-23 Ashar Tashree, by parda haseeno sy khabi dil na laga.mp3

            // step 2: split by space
            let nameParts = title.split(" "); // ["123", "My", "Audio", "File"]
            // step 3: merge except first element
            let nameOnly = nameParts.slice(1).join(" "); // "My Audio File"
            let firstElement = nameParts[0]; // "2022-08-23"
            // simple regex check for YYYY-MM-DD
            let isDate = /^\d{4}-\d{1,2}-\d{1,2}$/.test(firstElement);

            if (isDate) {
                array[this.formatIndex.title] = nameOnly
                array[this.formatIndex.date] = firstElement
            }
            else {
                array[this.formatIndex.title] = title
                array[this.formatIndex.date] = createdAt
            }
            return array;
        }
    }
    // 13_11_2020.mp3
    let dateArr = title.split('_');
    if (dateArr.length >= 3) {
        var year = dateArr[2] || "";

        if (year.length === 2) {
            year = "20" + year;
        }

        let dateString = `${dateArr[0]}-${dateArr[1]}-${year}`;

        let isDate = /^\d{4}-\d{1,2}-\d{1,2}$/.test(dateString);

        if (isDate) {
            array[this.formatIndex.date] = dateString
        }
        else {
            array[this.formatIndex.date] = createdAt
        }


        const fullDate = new Date(`${year}-${dateArr[1]}-${dateArr[0]}`);
        const day = fullDate.getDay();

        let dayString = this.dayNames[day]

        if (this.dayNames.includes(dayString)) {
            array[this.formatIndex.title] = `${dayString} Majlis`
        } else {
            array[this.formatIndex.title] = title
        }

        return array;
    }
    else {
        // Agar split me kam values milen to default assign karo
        array[this.formatIndex.date] = createdAt;
        array[this.formatIndex.title] = title;
        return array;
    }

}

exports.formatIndex = {
    date: 0,
    title: 1,
    extension: 2
}

exports.formatIndexMASSSpeech = {
    date: 0,
    title: 1,
    extension: 2
}

exports.formatIndexForDescription = {
    title: 0,
    description: 1
}


exports.dayNames = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];

exports.extractAllFromPdfFiles = (name) => {
    let array = ["", "", ""];
    array[this.formatIndexForPdf.name] = name

    let tempArray = name.split('.');
    array[this.formatIndexForPdf.extension] = tempArray[tempArray.length - 1];

    var tempTitle = tempArray[0];
    tempTitle = tempTitle.replaceAll("_", " ");
    tempTitle = tempTitle.replaceAll("-", " ");
    array[this.formatIndexForPdf.title] = tempTitle

    return array;
}

exports.formatIndexForPdf = {
    title: 0,
    name: 1,
    extension: 2,
}

exports.extractAllFromAshaarFileName = (name, createdAt, updatedAt) => {
    let array = ["", "", ""]; //date$$title$$extension
    let tempArray = name.split('.');
    let title = tempArray[0];
    let dateRegix = /^(?:(?:31(\/|-|\.)(?:0?[13578]|1[02]))\1|(?:(?:29|30)(\/|-|\.)(?:0?[13-9]|1[0-2])\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})$|^(?:29(\/|-|\.)0?2\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:0?[1-9]|1\d|2[0-8])(\/|-|\.)(?:(?:0?[1-9])|(?:1[0-2]))\4(?:(?:1[6-9]|[2-9]\d)?\d{2})$/
    let splitTile = title.split(' ');
    let firstElement = splitTile[0];

    array[this.formatAshaarIndex.title] = title
    array[this.formatAshaarIndex.date] = createdAt

    if (dateRegix.test(firstElement)) {
     
        let dateArray = firstElement.split('-');
        var year = dateArray[2];
        if (year.length == 2) {
            year = "20" + year;
        }
        let dateString = `${dateArray[0]}-${dateArray[1]}-${year}`;
        let nameOnly = splitTile.slice(1).join(" "); // "My Audio File"
        // regex for DD-MM-YYYY or D-M-YYYY
        const isDate = /^\d{1,2}-\d{1,2}-\d{4}$/.test(dateString);
        if (isDate) {
            if (typeof nameOnly === "string" && nameOnly.trim() !== "") {
                array[this.formatAshaarIndex.title] = nameOnly
            } else {
                array[this.formatAshaarIndex.title] = 'Ashaar'
            }
            array[this.formatAshaarIndex.date] = dateString
        }

    }
    else {
        let recTileArray = firstElement.split('-');
        var recTile = recTileArray[0];
        if (recTile.includes("rec")) {
            // rec1225-143934.mp3
            recTile = recTile.replace("rec", "");
            let recDateRegix = /^(\w{4})$/
            if (recDateRegix.test(recTile)) {
                let month = recTile.substring(0, 2);
                let date = recTile.substring(2, 4);

                let createdDate = new Date(createdAt);
                let year = createdDate.getFullYear();

                let dateString = `${date}-${month}-${year}`;
                array[this.formatAshaarIndex.date] = dateString
                array[this.formatAshaarIndex.title] = 'Ashaar'
            }
        }

    }

    array[this.formatAshaarIndex.extension] = tempArray[tempArray.length - 1];
    return array;
}

exports.formatAshaarIndex = {
    date: 0,
    title: 1,
    extension: 2,
}


exports.extractAllFromShortVideoFiles = (name, createdAt, updatedAt) => {
    let array = ["", ""];

    let tempArray = name.split('.');
    array[this.formatIndexForShortVideo.extension] = tempArray[tempArray.length - 1];

    var tempTitle = tempArray[0];
    tempTitle = tempTitle.replaceAll("_", " ");
    tempTitle = tempTitle.replaceAll("-", " ");
    array[this.formatIndexForShortVideo.title] = tempTitle

    return array;
}

exports.formatIndexForShortVideo = {
    title: 0,
    extension: 1,
}

exports.extractAllFromFilesGeneral = (name, createdAt, updatedAt) => {
    let array = ["", "", ""];
    array[this.formatIndexForFilesGeneral.name] = name

    let tempArray = name.split('.');
    array[this.formatIndexForFilesGeneral.extension] = tempArray[tempArray.length - 1];

    var tempTitle = tempArray[0];
    tempTitle = tempTitle.replaceAll("_", " ");
    tempTitle = tempTitle.replaceAll("-", " ");
    array[this.formatIndexForFilesGeneral.title] = tempTitle

    return array;
}

exports.formatIndexForFilesGeneral = {
    title: 0,
    name: 1,
    extension: 2,
}


exports.makeFileNameFromSpeechFormat = (data) => {
    //date$$title$$name$$place$$islamiDate$$description$$extension
    //change because when user access file from drive name ajeeb sa lagta h
    let date = data.date
    var title = data.title
    title = title.replaceAll(" ", "-")

    let str = `${date}$$${title}`
    return str;
}

exports.getFormatedDate = (date1) => {
    let date = new Date(date1)
    return date.getDate() + "-" + date.getMonth() + "-" + date.getFullYear()
}