const express = require("express");
const router = express.Router();


const checkAuth = require("../middleware/check-auth");
const controller = require("../controllers/group_controller");


//checkAuth IS ASSIGNED TO THE ROUTE AS MIDDLEWARE BECAUSE ITS A PROTECTED ROUTE AND MUST PASS TOKEN VERIFICATION
router.post("/post", checkAuth,  controller.post);
router.post("/get_by_limit",    controller.getByLimit);
router.post("/get_by_id/:id",    controller.getById);
router.delete("/delete/:id", checkAuth, controller.delete);
router.put("/update/:id", checkAuth, controller.update);

router.post("/get_all",    controller.getAll);
router.post("/get_all_by_person_category",    controller.getAllByPersonAndCategory);

module.exports = router;