const express = require("express");
const router = express.Router();


const checkAuth = require("../middleware/check-auth");
const newsController = require("../controllers/news_controller");


//checkAuth IS ASSIGNED TO THE ROUTE AS MIDDLEWARE BECAUSE ITS A PROTECTED ROUTE AND MUST PASS TOKEN VERIFICATION
router.post("/post", checkAuth, newsController.post);
router.post("/get_by_limit", checkAuth, newsController.getByLimit);
router.post("/get_by_id/:id", checkAuth, newsController.getById);
router.delete("/delete/:id", checkAuth, newsController.delete);
router.put("/update/:id", checkAuth, newsController.update);

router.post("/get_latest_news",    newsController.getLatestNews);
router.post("/get_news",    newsController.getNews);


module.exports = router;
