const express = require("express");
const router = express.Router();


const checkAuth = require("../middleware/check-auth");
const videoController = require("../controllers/video_controller");


//checkAuth IS ASSIGNED TO THE ROUTE AS MIDDLEWARE BECAUSE ITS A PROTECTED ROUTE AND MUST PASS TOKEN VERIFICATION
router.post("/post_all",   checkAuth, videoController.post);
router.post("/post_video_by_id",   checkAuth, videoController.postVideoFileById);
router.post("/post_image_by_id",   checkAuth, videoController.postImageFileById);
router.post("/post_data",   checkAuth, videoController.postData);

router.post("/get_by_limit",   checkAuth, videoController.getByLimit);
router.post("/get_all",   checkAuth, videoController.getAll);
router.post("/get_by_id/:id",   checkAuth, videoController.getById);
router.delete("/delete/:id",   checkAuth, videoController.delete);
router.put("/update/:id",   checkAuth, videoController.update);

router.get("/download/:fileName",    videoController.download);
router.get("/get/:fileName",    videoController.get);

router.post("/get_all_by_type_person",    videoController.getAllByTypeAndPerson);
router.post("/get_all_by_person",    videoController.getAllByTypeAndPerson);
router.post("/get_all_by_type_person_category",    videoController.getAllByTypePersonCategory);
router.post("/get_all_by_category",    videoController.getAllByCategory);
router.post("/get_all_by_type",    videoController.getAllByType);
router.post("/get_all_by_Search",    videoController.getAllBySearch);
router.post("/get_by_type",    videoController.getByType);
module.exports = router;
