const express = require("express");
const upload = require('express-fileupload');
const app = express();
const morgan = require("morgan");
const bodyParser = require("body-parser");
const model = require("./database/models/model");
const path = require("path");

var swaggerUi = require("swagger-ui-express"),
  swaggerDocument = require("./api/swagger/swagger.json");

var customSwaggerOptions = {
  explorer: true,
  swaggerOptions: {
    authAction: {
      JWT: {
        name: "JWT",
        type: "apiKey",
        schema: {
          in: "header",
          name: "x-access-token",
          description: "",
        },
        value:
          "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6NiwiaWF0IjoxNTkyNTYyMDU3LCJleHAiOjE1OTI2NDg0NTd9.uyZxziVwMNL1vyf-EgC8_2mKebKM-rCSgX8_5bBKhvk",
      },
    },
  },
};
app.use(
  "/api-docs",
  swaggerUi.serve,
  swaggerUi.setup(swaggerDocument, customSwaggerOptions)
);

app.use(upload());

// ✅ Add this line (missing earlier)
app.use(express.json());

const userRoutes = require("./api/routes/user");
const audioRoutes = require("./api/routes/audio");
const pdfRoutes = require("./api/routes/pdf");
const personRoutes = require("./api/routes/person");
const typeRoutes = require("./api/routes/type");
const categoryRoutes = require("./api/routes/category");
const imagesRoutes = require("./api/routes/images");
const newsRoutes = require("./api/routes/news");
const sliderRoutes = require("./api/routes/slider");
const followerRoutes = require("./api/routes/follower");
const googleDriveRoutes = require("./api/routes/googleDrive");
const videoRoutes = require("./api/routes/video");
const groupRouts = require("./api/routes/group");

app.use(morgan("dev")); // it will log all the requests.
app.use(bodyParser.urlencoded({ extended: false })); 
app.use(bodyParser.json()); 

//handling cors
app.use((req, res, next) => {
  res.header("Access-Control-Allow-Origin", "*");
  res.header(
    "Access-Control-Allow-Headers",
    "Origin,X-Requested-With,Content-Type,Accept,Authorization"
  );
  if (req.method === "OPTIONS") {
    res.header("Access-Control-Allow-Methods", "PUT,POST,GET,DELETE,PATCH");
    return res.status(200).json({});
  }
  next();
});

app.use(express.static('public'));
app.use('/images', express.static('uploads'));

app.use("/user", userRoutes);
app.use("/audio", audioRoutes);
app.use("/pdf", pdfRoutes);
app.use("/type", typeRoutes);
app.use("/person", personRoutes);
app.use("/category", categoryRoutes);
app.use("/image", imagesRoutes);
app.use("/news", newsRoutes);
app.use("/slider", sliderRoutes);
app.use("/follower", followerRoutes);
app.use("/google-drive", googleDriveRoutes);
app.use("/video", videoRoutes);
app.use("/group", groupRouts);

// Serve admin panel build at /admin
app.use('/admin', express.static(path.join(__dirname, 'ks_adminpanel/build')));
app.get('/admin/*', (req, res) => {
  res.sendFile(path.join(__dirname, 'ks_adminpanel/build', 'index.html'));
});

//Serve frontend
app.use(express.static(path.join(__dirname, 'frontend/dist')));
app.get('*', (req, res) => {
  if (req.originalUrl.startsWith('/admin')) {
    return res.sendStatus(404);
  }
  res.sendFile(path.join(__dirname, 'frontend/dist', 'index.html'));
});

//error handling
app.use((req, res, next) => {
  const error = new Error("not found");
  error.status = 404;
  next(error);
});

app.use((error, req, res, next) => {
  res.status(error.status || 500);
  res.json({
    error: {
      message: error.message,
      code: error.status,
    },
  });
});



module.exports = app;
