const Sequelize = require("sequelize");
const db = require("../connection");
const category = require('./category');
const person = require('./person');

const table = db.define(
  "group",
  {
    id: {
      type: Sequelize.BIGINT(11),
      autoIncrement: true,
      primaryKey: true,
    },
    orignalId: {
      type: Sequelize.STRING(255),
      unique: true,
    },
    categoryId: {
      type: Sequelize.BIGINT(11),
    },
    personId: {
      type: Sequelize.BIGINT(11),
    },
    title: {
      type: Sequelize.STRING(255),
    },
  },
  {
    paranoid: true,
    timestamps: true,
    // disable the modification of tablenames; By default, sequelize will automatically
    // transform all passed model names (first parameter of define) into plural.
    // if you don't want that, set the following
    freezeTableName: true,
    // define the table's name
    tableName: "group",
  }
);
table.belongsTo(category, {as: 'category'});
table.belongsTo(person, {as: 'person'});
person.hasMany(table, {as: 'group'});
category.hasMany(table, {as: 'group'});

module.exports = table;