'use strict';
const { typeNameShortForm, type } = require("../constants/dbConstants");

module.exports = {
  up: async (queryInterface, Sequelize) => {
    return queryInterface.bulkInsert('types', [
      {
        id: type.Poetry,
        title: typeNameShortForm.PO,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: type.Speech,
        title: typeNameShortForm.SP,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: type.Dhikr,
        title: typeNameShortForm.DH,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: type.Book,
        title: typeNameShortForm.BO,
        createdAt: new Date(),
        updatedAt: new Date()
      },
      {
        id: type.Video,
        title: typeNameShortForm.VI,
        createdAt: new Date(),
        updatedAt: new Date()
      },
  ]);
  },

  down: async (queryInterface, Sequelize) => {
    return queryInterface.bulkDelete('types', null, {});
  }
};
